﻿using System;

namespace gov.va.med.VBECS.Communication.Common
{
    [Serializable]
    public class BaseMessage : IMessage
    {
        public string Id { get; set; }

        public string RepliedId { get; set; }

        public virtual byte[] GetBytes()
        {
            throw new NotImplementedException();
        }

        public BaseMessage()
        {
            Id = Guid.NewGuid().ToString();
        }

        public BaseMessage(string theRepliedId)
            : this()
        {
            RepliedId = theRepliedId;
        }
    }
}
